/* ****************************************************************************
 * Copyright: 2017-2025 RAYLASE GmbH
 * This source code is the proprietary confidential property of RAYLASE GmbH.
 * Reproduction, publication, or any form of distribution to
 * any party other than the licensee is strictly prohibited.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */

/***********************************************************************************************
 * Only this header-file has to be included in your application to use the RAYLASE SP-ICE-3 API.
 * Everything is included from this file.
 ***********************************************************************************************/
#ifndef SPICE3_CLIENT_API_
#define SPICE3_CLIENT_API_

/* Global defines and types used in the SPICE3 API */
#include "rlTypes.h"

/* All headers containing the API function calls are included here */
#include "AdapterBoardAPI.h"
#include "ConfigurationAPI.h"
#include "EventAPI.h"
#include "FontAPI.h"
#include "GpioAPI.h"
#include "HeadCorrectionAPI.h"
#include "InternalAPI.h"
#include "LaserAPI.h"
#include "ListAPI.h"
#include "MotFAPI.h"
#include "PowerCorrectionAPI.h"
#include "ProcessAPI.h"
#include "ScannerAPI.h"
#include "ScannerCommunicationAPI.h"
#include "SerialPortAPI.h"
#include "SfioAPI.h"
#include "SystemAPI.h"
#include "VariableAPI.h"

RL_C_API rlHandle rlConnect(const char* hostNameOrAddress, int32_t port);
RL_C_API rlHandle rlConnectByCardInfo(const rlCardInfo* card);
RL_C_API rlResult rlIsConnected(rlHandle handle, bool* isConnected);
RL_C_API rlResult rlDisconnect(rlHandle connection);
RL_C_API rlResult rlDiscover(rlCardInfo* discoveredCards, uint32_t discoveredCardsSize, uint32_t* discoveredCardsCount);
#ifdef _WIN32
    RL_C_API rlResult rlDiscoverByPinging(
        int32_t fromSerialNumber, int32_t toSerialNumber, rlCardInfo* discoveredCards, uint32_t discoveredCardsSize, uint32_t* discoveredCardsCount);
    RL_C_API rlResult rlDiscoverByPingingCustomized(int32_t fromSerialNumber, int32_t toSerialNumber, rlCardInfo* discoveredCards, uint32_t discoveredCardsSize,
        uint32_t* discoveredCardsCount, int32_t repetitions /* Default: 2 */, int32_t pingTimeoutMs /* Default: 1000 */,
        int32_t maxNumAddressesToPingInParallel /* Default: 50 */);
#endif // _WIN32
RL_C_API rlResult rlPredictIPAddressFromSerialNumber(
    const char* serialNumber, const rlCardDisposition cardDisposition, bool useIPv6, char* ipAddress, const uint32_t ipAddressSize);
RL_C_API rlResult rlEnableCommandLogging(rlHandle handle, const char* path, int32_t truncateArgumentsAfter);
RL_C_API rlResult rlDisableCommandLogging(rlHandle handle);
RL_C_API rlResult rlSetTimeout(rlHandle handle, uint32_t timeout);
RL_C_API rlResult rlGetTimeout(rlHandle handle, uint32_t* outTimeout);

#endif // SPICE3_CLIENT_API_
